#ifndef ZMODELER_STRUCT_STATE_INCLUDED
#define ZMODELER_STRUCT_STATE_INCLUDED

/*************************************/
//  Current State, Mode, Level;
/*************************************/
DllExport BOOL IsAlternateMode();
DllExport BOOL IsShiftMode();
DllExport BOOL IsCtrlMode();

class DllExport tState
{
//------------------------------------
//  Data members:
private:
  DWORD    Mode;
  DWORD    DrawMode;
  UINT    MultyRadius;
  z3dLevels  Level;
  z3dState  State;
  z3dEditMode  EditMode;  //X,Y,XY
  char    StatusMessage[255];
public:
  z3dLevels  ExpectLevel;
  int      ExtRadius1, ExtRadius2, ExtRadius3;
  int      UndoMaxSteps;
  CString    ApplicationPath;

  //////////////////////////
  // Settings and options
  DWORD    nUnitsFlags;
  DWORD    nOpenSaveFlags;
  DWORD    nCurrentViewFlags;
  DWORD    nReserv2Flags;
  DWORD    nReserv3Flags;
  DWORD    nReserv4Flags;
  
  z3dProcsSet CurrentProcs;
  z3dProcsSet AlternateProcs;//set of procs
  tProcParams  CurrentParams;

//------------------------------------
//  Construction:
  tState();

//------------------------------------
//  Functions:
  BOOL IsSelectedMode();  //is SELected mode on?
  BOOL IsMultyMode();    //is MULtiple mode on?
  BOOL IsExtendedMode();  //is EXTended mode on?

  BOOL IsMode(DWORD checkmode);  //check for Z3D_MODE_
  BOOL IsDrawMode(DWORD checkmode);//check for Z3D_DRAWMODE_

  UINT GetMultyRadius();  //redius of activation precision
  DWORD GetMode();    //returns DWORD Mode
  DWORD GetDrawMode();  //returns DWORD DrawMode

  void SwitchMode(DWORD switchmode);  //set/unset custom mode
  void SetMode(DWORD mode);      //set custom mode
  void SetDrawMode(DWORD mode);    //set custom drawmode

  z3dEditMode GetEditMode();      //returns z3dEditMode (X,Y,..)
  void SetEditMode(z3dEditMode NewMode);  //sets z3dEditMode (X,Y,..)
  BOOL IsEditMode(z3dEditMode CheckForMode);  //checks for z3dEditMode (X,Y,..)

  z3dLevels GetLevel();          //returns current level (z3dLevels)
  BOOL IsLevel(z3dLevels CheckForLevel);  //checks for custom level (z3dLevels)
  void SetLevel(z3dLevels NewLevel);    //sets new level (z3dLevels)

  z3dState GetState();          //returns current state (z3dState)
  BOOL IsState(z3dState CheckForState);  //checks for custom state (z3dState)
  void SetState(z3dState NewState);    //sets new state (z3dState)
  
  void  SetMessage(char* str);  //sets statusbar message
  char*  GetMessage();      //return StatusMessage
};

#endif
